﻿/*
version:		1.0
*/

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
// XML Loading function
function readXml( parentPath, targetData )
{
	// loop through attributes
	for ( childName in parentPath.attributes)
	{
		// create a new variable
		// // Ignore "xmlType", since they're only used to help the parser.
		if (childName != "xmlType")
		{
			var newValue = parentPath.attributes[childName];
			// if it's a number, store is as one
			if ( isNaN( Number(newValue) )  )
			{
				// check if it's actually a boolean value
				if ( newValue == "true")
				{
					targetData[childName] = true;
				}else if( newValue == "false")
				{
					targetData[childName] = false;
				}else{
					// store as a string
					targetData[childName] = newValue;
				}// END:  if (newValue == "true"  "false" )
			}else{
				// store as a number
				targetData[childName] = Number(newValue);
			}// END:  if (is a string)
		}
		delete childName;
	}// END:  for...in (parentPath.attributes)
	
	// loop through all the nodes
	for ( childIndex in parentPath.childNodes)
	{
		var childPath:XMLNode = parentPath.childNodes[childIndex];
		var childName = childPath.nodeName;
		// read the type
		var childType:String = childPath.attributes.xmlType;
		// create variable according to type
		
		if (childType == "array" )
		{
			// create new array
			targetData[childName] = new Array();
			// read the elements for this new array
			var childData = targetData[childName];
			//showLoadedData();
			readXml( childPath, childData );
		}// END:  if (array)
		
		else	if (childType == "variable" )
		{
			// create a new variable
			newValue = childPath.attributes.value;
			// if it's a number, store is as one
			if ( isNaN( Number(newValue) )  )
			{
				// store as a string
				targetData[childName] = newValue;
			}else{
				// store as a number
				targetData[childName] = Number(newValue);
			}
		}// END:  if (variable)
		
		else if (childType == "object" )
		{
			// create a new object
			targetData[childName] = new Object();
			// read the elements for this new array
			var childData = targetData[childName];
			// read the variables of this new object
			readXml( childPath, childData );
		}// END:  if (object)

	}// END:  for...in (parentPath.childNodes)
	delete childIndex;
}
// END:	XML Loading function
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
